(function (ns) {

ns.PasswordControlBalloon = function(settings, locales, callFunction, session)
{
	var m_balloon = (window == window.top) ? new ns.Balloon(OnCreateBalloon, UpdateBalloon, "/pc/tooltip.css") : null;
	var m_mainDiv = null;
	var m_focusedElement = null;
	var m_lastChange = null;
	var m_hideTimer = null;
	var m_displayBalloon = false;
	var m_currentVerdictClassName = "popup_weak";
	var m_currentArrowClassName = "arrow-show-left";
	var m_needShowAdditionalMenu = false;

	var m_skipFocusBlur = false;

	var m_focusEventName;
	var m_blurEventName;
	if (window.addEventListener)
	{
		m_focusEventName = "focus";
		m_blurEventName = "blur";
	}
	else
	{
		m_focusEventName = "focusin";
		m_blurEventName = "focusout";
	}

	function CreateElement(type, className, text, clickHandler)
	{
		var el = document.createElement(type);
		el.className = className;
		if (text)
			el.innerHTML = text;
		if (clickHandler)
			ns.AddEventListener(el, "click", clickHandler);
		return el;
	}

	function CreateDiv(className)
	{
		return CreateElement("div", className);
	}

	function OnCreateBalloon(element, document)
	{
		m_mainDiv = CreateDiv("");

		ns.AddEventListener(m_mainDiv, "mouseover", OnBalloonFocus);
		ns.AddEventListener(m_mainDiv, "mouseout", OnBalloonFocus);
		ns.AddEventListener(m_mainDiv, "click", OnBalloonClick);

		m_mainDiv.appendChild(CreateDiv("arrow-top"));
		m_mainDiv.appendChild(CreateDiv("arrow-left"));

		var popupDiv = CreateDiv("popup");
		var popupHeaderDiv = CreateDiv("popup-header");
		popupHeaderDiv.appendChild(CreateDiv("logo"));

		var popupTitleDiv = CreateDiv("popup-title");
		popupTitleDiv.appendChild(CreateElement("p", "verdict-title", locales["PasswordControlVerdictTitle"]))

		var verdictAreaDiv = CreateDiv("verdict");
		verdictAreaDiv.appendChild(CreateElement("p", "verdict_strong popup-body-password-strength", locales["PasswordControlVerdictStrong"]));
		verdictAreaDiv.appendChild(CreateElement("p", "verdict_average popup-body-password-strength", locales["PasswordControlVerdictAverage"]));
		verdictAreaDiv.appendChild(CreateElement("p", "verdict_weak popup-body-password-strength", locales["PasswordControlVerdictWeak"]));
		popupTitleDiv.appendChild(verdictAreaDiv);
		popupHeaderDiv.appendChild(popupTitleDiv);

		var popupTitleEmptyDiv = CreateDiv("popup-title-empty");
		popupTitleEmptyDiv.appendChild(CreateElement("p", "verdict-title", locales["PasswordControlEmptyHeader"]));
		popupHeaderDiv.appendChild(popupTitleEmptyDiv);

		popupHeaderDiv.appendChild(CreateElement("button", "popup-header__close-button", "", OnCloseButton));
		popupHeaderDiv.appendChild(CreateElement("button", "popup-header__hide-button", "", OnShowSubmenu));
		popupHeaderDiv.appendChild(CreateElement("div", "popup-header__hide-menu", locales["PasswordControlSkipNotification"], OnSkipNotification));
		popupDiv.appendChild(popupHeaderDiv);
		popupDiv.appendChild(CreateElement("p", "password-empty password-empty-hidden", locales["PasswordControlKpmSuggestion"]));

		var popupBodyDiv = CreateDiv("popup-body");

		popupBodyDiv.appendChild(CreateElement("p", "password-recomendations", locales["PasswordControlRecommendations"]));
		var recommendationList = CreateElement("ul", "password-recomendations-list");
		recommendationList.appendChild(CreateElement("li", "reason-length", locales["PasswordControlRecommendationLength"]));
		recommendationList.appendChild(CreateElement("li", "reason-keyboard", locales["PasswordControlRecommendationKeyboard"]));
		recommendationList.appendChild(CreateElement("li", "reason-frequent-words", locales["PasswordControlRecommendationFrequentWords"]));
		recommendationList.appendChild(CreateElement("li", "reason-alternation", locales["PasswordControlRecommendationAlternation"]));
		popupBodyDiv.appendChild(recommendationList);
		popupDiv.appendChild(popupBodyDiv);

		var popupFooterDiv = CreateDiv("popup-footer");
		var areaButtons = CreateDiv("ps_area_buttons");
		var buttonButton = CreateElement("button", "button", "", OnInstallButton);
		buttonButton.appendChild(CreateElement("span", "", locales["PasswordControlRecomendation"]));
		areaButtons.appendChild(buttonButton);
		popupFooterDiv.appendChild(areaButtons);
		popupDiv.appendChild(popupFooterDiv);

		m_mainDiv.appendChild(popupDiv);
		m_mainDiv.appendChild(CreateDiv("arrow-right"));
		m_mainDiv.appendChild(CreateDiv("arrow-bottom"));

		element.appendChild(m_mainDiv);
	}

	function OnCloseButton()
	{
		if (m_focusedElement)
		{
			m_focusedElement.focus();
			ns.RemoveEventListener(m_focusedElement, "input", OnInput);
			ns.RemoveEventListener(m_focusedElement, m_blurEventName, OnBlur);
		}
		m_focusedElement = null;
		m_lastChange = null;
		HideBalloon();
	}

	function OnShowSubmenu(event)
	{
		m_needShowAdditionalMenu = !m_needShowAdditionalMenu;
		UpdatePopupClassName();
		ns.StopProcessingEvent(event);
	}

	function OnSkipNotification()
	{
	    DisableImpl();
		callFunction("pc.SkipNotification");
	}

	function OnInstallButton()
	{
		OnCloseButton();
		callFunction("pc.Download");
	}

    this.Disable = function ()
    {
        DisableImpl();
	}

	function DisableImpl()
	{
		if (m_balloon)
		    m_balloon.Hide();

		m_balloon = null;
		ns.RemoveEventListener(m_focusedElement, m_blurEventName, OnBlur);
		ns.RemoveEventListener(m_focusedElement, "input", OnInput);
		ns.RemoveEventListener(m_focusedElement, "keyup", OnInput);
		ns.RemoveEventListener(m_focusedElement, "keydown", OnInput);
		session.Log("Disabling password control");
	}

	function UpdatePopupClassName()
	{
		if (!m_mainDiv)
			return;

		m_mainDiv.className = m_currentVerdictClassName + " " + m_currentArrowClassName;
		if (m_needShowAdditionalMenu)
			m_mainDiv.className += " show_hide_menu";
	}

	function UpdateBalloon()
	{
		if (!m_focusedElement)
			return;

		m_needShowAdditionalMenu = false;
		if (m_focusedElement.value)
		{
			var passwordStrength = ns.CheckPasswordStrength(m_focusedElement.value);
			var strengthName;
			switch (passwordStrength.quality)
			{
				case 0:  
				case 1:  strengthName = "strong"; break;
				case 2:  strengthName = "average"; break;
				default: strengthName = "weak"; break;
			}
			var className = "popup_" + strengthName;
			if (passwordStrength.quality > 1)
			{
				className += " " + strengthName + "-reason-";
				switch (passwordStrength.reasons[0])
				{
					case 0:
					case 4: className += "keyboard"; break;
					case 1: className += "frequent-words"; break;
					case 2: className += "length"; break;
					case 3: className += "alternation"; break;
				}
			}
			m_currentVerdictClassName = className;
		}
		else
		{
			m_currentVerdictClassName = "popup_empty";
		}

		UpdateKPMInfoVisibility();
		UpdatePopupClassName();
	}

	function GetCoord(balloonSize)
	{
		var coord = {x: 0, y: 0};
		if (!m_focusedElement)
			return coord;
		var elementRect = m_focusedElement.getBoundingClientRect();
		var clientHeight = ns.GetPageHeight();
		var clientWidth = ns.GetPageWidth();

		m_currentArrowClassName = "arrow-show-";
		if (elementRect.right + balloonSize.width <= clientWidth)
		{
			m_currentArrowClassName += "left";
			coord.x = elementRect.right;
			coord.y = elementRect.top - 80 + (elementRect.bottom - elementRect.top) / 2;
		}
		else if (elementRect.left - balloonSize.width >= 0)
		{
			m_currentArrowClassName += "right";
			coord.x = elementRect.left - balloonSize.width;
			coord.y = elementRect.top  - 80 + (elementRect.bottom - elementRect.top) / 2;
		}
		else if (elementRect.bottom + balloonSize.height < clientHeight)
		{
			m_currentArrowClassName += "top";
			coord.x = elementRect.left  - 13;
			coord.y = elementRect.bottom;
		}
		else if (elementRect.top - balloonSize.height > 0)
		{
			m_currentArrowClassName += "bottom";
			coord.x = elementRect.left  - 13;
			coord.y = elementRect.top - balloonSize.height;
		}
		else
		{
			m_currentArrowClassName += "top";
			coord.x = elementRect.left - 13;
			coord.y = elementRect.bottom;
		}
		UpdatePopupClassName();

		var scroll = ns.GetPageScroll();
		coord.x += scroll.left;
		coord.y += scroll.top;

		return coord;
	}

	function ShowBalloon()
	{
	    if (!m_balloon)
	        return;
		if (!m_displayBalloon)
		{
			callFunction("pc.Tooltip");
			m_displayBalloon = true;
		}
		m_balloon.Show(GetCoord);
		UpdateKPMInfoVisibility();
	}

	function HideBalloon()
	{
		m_balloon.Hide();
		m_displayBalloon = false;
	}

	function OnInput()
	{
		try
		{
			if (!m_focusedElement)
				return;
			if (m_lastChange == m_focusedElement.value)
				return;
			ShowBalloon();
			m_lastChange = m_focusedElement.value;
		}
		catch(e)
		{
			ns.SessionLog(e);
		}
	}

	function UpdateKPMInfoVisibility() {
		if (!m_balloon)
			return;
		if (!m_mainDiv)
			return;
		var passwd = m_mainDiv.getElementsByClassName("password-empty")[0];
		if (m_focusedElement.value.length == 0) {
			passwd.className = "password-empty"
		} else {
			passwd.className = "password-empty password-empty-hidden"
		}
	}

	function OnFocus(evt)
	{
	    if (!m_balloon)
	        return;
		if (m_skipFocusBlur)
		{
			if (m_focusedElement)
				m_focusedElement.focus();
			return;
		}
		var element = evt.target || evt.srcElement;

		if ( !ns.NeedToShowBalloon(element) )
			return;

		m_focusedElement = element;

		clearTimeout(m_hideTimer);
		ShowBalloon();

		ns.AddRemovableEventListener(element, m_blurEventName, OnBlur);
		ns.AddRemovableEventListener(element, "input", OnInput);

		ns.AddRemovableEventListener(element, "keyup", OnInput);
		ns.AddRemovableEventListener(element, "keydown", OnInput);
	}

	function OnBlur()
	{
		try
		{
			if (m_skipFocusBlur)
			{
				if (m_focusedElement)
					ns.SetTimeout(function(){m_focusedElement.focus();}, 0);
				return;
			}
			if (m_focusedElement)
			{
				clearTimeout(m_hideTimer);
				m_hideTimer = ns.SetTimeout(function (){HideBalloon();}, 100);

				ns.RemoveEventListener(m_focusedElement, m_blurEventName, OnBlur);
				ns.RemoveEventListener(m_focusedElement, "input", OnInput);
				ns.RemoveEventListener(m_focusedElement, "keyup", OnInput);
				ns.RemoveEventListener(m_focusedElement, "keydown", OnInput);
				m_focusedElement = null;
				m_lastChange = null;
			}
		}
		catch (e)
		{
			ns.SessionLog(e);
		}
	}

	function OnBalloonFocus(event)
	{
		if (event.type == "mouseover")
			m_skipFocusBlur = true;
		else if (event.type == "mouseout")
			m_skipFocusBlur = false;
	}
	function OnBalloonClick(event)
	{
		if (m_needShowAdditionalMenu)
		{
			m_needShowAdditionalMenu = false;
			UpdatePopupClassName();
		}
	}


	ns.AddEventListener(document, m_focusEventName, OnFocus);
}

}) (KasperskyLab || {});
